#include "ScnChooseSkin.h"
#include "freestyledash.h"

HRESULT CScnChooseSkin::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
    GetChildById( L"Skin", &m_Skin );

	LoadSkinList();

	return S_OK;
}

void CScnChooseSkin::LoadSkinList()
{
	int Count = m_Skin.GetItemCount();
	m_Skin.DeleteItems(0,Count);

	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	string searchcmd = "game:\\skin\\*";
	searchcmd = str_replaceallA(searchcmd,"\\\\","\\");
	DebugMsg("Scanning %s for skins",searchcmd.c_str());

	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return;

	int SkinsNo = 0;
	do {
		DebugMsg(findFileData.cFileName);
		Skins[SkinsNo] = strtowstr(findFileData.cFileName).c_str();
		SkinsNo++;
	} while (FindNextFile(hFind, &findFileData));
	FindClose(hFind);

	m_Skin.InsertItems(0,Skins.size());
	int Current = 0;

	for (unsigned int i = 0 ; i < Skins.size() ; i++)
	{
		m_Skin.SetText(i,Skins[i].c_str());
		if (Skins[i] == cl.skin)
			Current = i;
	}
	m_Skin.SetItemCheck(Current,true);
}

HRESULT CScnChooseSkin::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    return( S_OK );
}

HRESULT CScnChooseSkin::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{

	if (hObjPressed == m_Skin)
	{
		int Current = m_Skin.GetCurSel();
		for (unsigned int i = 0 ; i < Skins.size() ; i++)
		{
			m_Skin.SetItemCheck(i,false);
		}
		m_Skin.SetItemCheck(Current,true);
		cl.skin = Skins[Current];
		DoSaveSettings();
		bHandled = TRUE;
	} 

    return S_OK;
}